/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.message;

import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.message.VWValidationToolTip;
import filenet.vw.toolkit.design.message.images.VWImageLoader;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class VWValidationErrorTypeTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private VWWorkflowDefinition m_wflDefinition = null;
    private static ImageIcon m_textAnnotationIcon = null;
    private static ImageIcon m_dataFieldIcon = null;
    private static ImageIcon m_attachmentFieldIcon = null;
    private static ImageIcon m_wfGroupFieldIcon = null;
    private static ImageIcon m_instructionIcon = null;
    private static ImageIcon m_milestoneIcon = null;
    private static ImageIcon m_parameterIcon = null;
    private static ImageIcon m_routeIcon = null;
    private static ImageIcon m_stepIcon = null;
    private static ImageIcon m_workflowIcon = null;
    private static ImageIcon m_workflowCollectionIcon = null;

    public VWValidationErrorTypeTableCellRenderer(VWWorkflowDefinition wflDefinition) {
        try {
            this.setOpaque(true);
            this.m_wflDefinition = wflDefinition;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void setWorkflowDefinition(VWWorkflowDefinition wflDefinition) {
        this.m_wflDefinition = wflDefinition;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ImageIcon icon = null;
        VWValidationError error = null;
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
        }
        if (value instanceof VWValidationError) {
            error = (VWValidationError)value;
            icon = VWValidationErrorTypeTableCellRenderer.getErrorTypeIcon(error.getErrorType(), error.getName(), this.m_wflDefinition);
        }
        this.setText(null);
        this.setToolTipText(VWValidationToolTip.createValidationToolTip(error));
        this.setIcon(icon);
        return this;
    }

    public static ImageIcon getErrorTypeIcon(int nErrorType, String errorName, VWWorkflowDefinition wflDefinition) {
        switch (nErrorType) {
            case 12: {
                if (m_textAnnotationIcon == null) {
                    m_textAnnotationIcon = VWImageLoader.createImageIcon("textAnnotation.gif");
                }
                return m_textAnnotationIcon;
            }
            case 4: {
                switch (VWValidationErrorTypeTableCellRenderer.getFieldType(errorName, wflDefinition)) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: 
                    case 128: {
                        if (m_dataFieldIcon == null) {
                            m_dataFieldIcon = VWImageLoader.createImageIcon("data.gif");
                        }
                        return m_dataFieldIcon;
                    }
                    case 32: 
                    case 512: {
                        if (m_attachmentFieldIcon == null) {
                            m_attachmentFieldIcon = VWImageLoader.createImageIcon("attachment.gif");
                        }
                        return m_attachmentFieldIcon;
                    }
                    case 64: {
                        if (m_wfGroupFieldIcon == null) {
                            m_wfGroupFieldIcon = VWImageLoader.createImageIcon("wfgroup.gif");
                        }
                        return m_wfGroupFieldIcon;
                    }
                }
                break;
            }
            case 7: {
                if (m_instructionIcon == null) {
                    m_instructionIcon = VWImageLoader.createImageIcon("instruction.gif");
                }
                return m_instructionIcon;
            }
            case 8: {
                if (m_milestoneIcon == null) {
                    m_milestoneIcon = VWImageLoader.createImageIcon("prepostmilestone.gif");
                }
                return m_milestoneIcon;
            }
            case 3: {
                if (m_parameterIcon == null) {
                    m_parameterIcon = VWImageLoader.createImageIcon("parameter.gif");
                }
                return m_parameterIcon;
            }
            case 10: {
                if (m_workflowIcon == null) {
                    m_workflowIcon = VWImageLoader.createImageIcon("workflow.gif");
                }
                return m_workflowIcon;
            }
            case 2: {
                if (m_routeIcon == null) {
                    m_routeIcon = VWImageLoader.createImageIcon("route.gif");
                }
                return m_routeIcon;
            }
            case 9: {
                if (m_workflowIcon == null) {
                    m_workflowIcon = VWImageLoader.createImageIcon("workflow.gif");
                }
                return m_workflowIcon;
            }
            case 11: {
                if (m_workflowIcon == null) {
                    m_workflowIcon = VWImageLoader.createImageIcon("workflow.gif");
                }
                return m_workflowIcon;
            }
            case 1: {
                if (m_stepIcon == null) {
                    m_stepIcon = VWImageLoader.createImageIcon("step.gif");
                }
                return m_stepIcon;
            }
            case 6: {
                if (m_workflowIcon == null) {
                    m_workflowIcon = VWImageLoader.createImageIcon("workflow.gif");
                }
                return m_workflowIcon;
            }
            case 13: {
                if (m_workflowCollectionIcon == null) {
                    m_workflowCollectionIcon = VWImageLoader.createImageIcon("workflowCollection.gif");
                }
                return m_workflowCollectionIcon;
            }
        }
        return null;
    }

    private static int getFieldType(String fieldName, VWWorkflowDefinition wflDefinition) {
        int nFieldType;
        block3: {
            nFieldType = 1;
            try {
                VWFieldDefinition[] fieldDefs;
                if (wflDefinition == null || (fieldDefs = wflDefinition.getFields()) == null || fieldDefs.length <= 0) break block3;
                for (int i = 0; i < fieldDefs.length; ++i) {
                    if (VWStringUtils.compare(fieldDefs[i].getName(), fieldName) != 0) continue;
                    nFieldType = fieldDefs[i].getFieldType();
                    break;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return nFieldType;
    }
}

